/*!
 #
 #
 # Sitecore Content Hub plugin for tinyMCE
 #
 #
 */
(function () {
        tinymce.PluginManager.add("ContentHub", function (editor, url) {
            /*
            Used to store a reference to the dialog when we have opened it
             */
            var _dialog = false;

            var _dialogConfig = {
                title: 'Content Hub',
                url: "https://testwordpress.stylelabs.io/en-us/sitecore-dam-connect/approved-assets",
                width: 600,
                height: 600
            };
            // Define the Toolbar button
            editor.addButton('ContentHub', {
                    image: url + '/icons/logo.png',
                    tooltip: "Sitecore Content Hub",
                    title:"ContentHub",
                    cmd: "ContentHub"
            });

            editor.addCommand('ContentHub', function(e){
                //_dialog = editor.windowManager.openUrl(_dialogConfig);
                _dialog = editor.windowManager.open({
                    title: 'Pick Import',
                    width: 600,
                    height: 600,
                    html: '<iframe src="' + _dialogConfig.url +'"></iframe>',
                    buttons:[{
                        text: 'Close',
                        onclick: 'close'
                    }]
                });
            });
            window.removeEventListener("message", window.mconnectMsgHandler);
            window.addEventListener("message", window.mconnectMsgHandler);
        });
    
    var msgHandler = function(event){
        if(event.data && event.data.__type) {
            tinyMCE.activeEditor.insertContent('<img src="' +  event.data.public_link +'" alt="image"/>');
            tinymce.activeEditor.windowManager.close();
        }
    };

    window.mconnectMsgHandler = window.mconnectMsgHandler || msgHandler;

})();