<?php
/**
 * Plugin Name: ContentHub
 * Plugin URI: http://wpbeginner.com
 * Version: 1.0
 * Author: WPBeginner
 * Author URI: https://www.wpbeginner.com
 * Description: A simple TinyMCE Plugin to add a sitecore connector in the Visual Editor
 * License: GPL2
 */
 
class ContentHub {
     
    /**
    * Constructor. Called when the plugin is initialised.
    */
    function __construct() {
		if ( is_admin() ) {
			add_action( 'init', array(  $this, 'setup_ContentHub_plugin' ) );
		}
    }

    /**
	 * Check if the current user can edit Posts or Pages, and is using the Visual Editor
	 * If so, add some filters so we can register our plugin
	 */

	function setup_ContentHub_plugin() {
	     
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
			return;
		}
	 
		if ( get_user_option( 'rich_editing' ) !== 'true' ) {
			return;
		}
	 
		add_filter( 'mce_external_plugins', array( &$this, 'add_ContentHub_plugin' ) );
		add_filter( 'mce_buttons', array( &$this, 'add_ContentHub_toolbar_button' ) );	     
	}


	/**
	 * Adds a TinyMCE plugin compatible JS file to the TinyMCE / Visual Editor instance
	 *
	 * @param array $plugin_array Array of registered TinyMCE Plugins
	 * @return array Modified array of registered TinyMCE Plugins
	 */

	function add_ContentHub_plugin( $plugin_array ) {
		$plugin_array['ContentHub'] = plugin_dir_url( __FILE__ ) . 'plugin.js';
		return $plugin_array; 
	}


	/**
	 * Adds a button to the TinyMCE / Visual Editor which the user can click
	 * to insert a link with a custom CSS class.
	 *
	 * @param array $buttons Array of registered TinyMCE Buttons
	 * @return array Modified array of registered TinyMCE Buttons
	 */

	function add_ContentHub_toolbar_button( $buttons ) {
		array_push( $buttons, '|', 'ContentHub' );
		return $buttons;
	}
}

$ContentHub = new ContentHub;